<?php
// تنظیمات
$telegram_bot_token = 'YOUR_BOT_TOKEN'; // توکن ربات تلگرام شما
$telegram_chat_id = 'YOUR_CHAT_ID'; // آیدی چت تلگرام شما

// پردازش فرم ثبت‌نام
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    if ($_POST['action'] === 'register') {
        // دریافت داده‌های فرم
        $name = htmlspecialchars($_POST['name']);
        $email = htmlspecialchars($_POST['email']);
        $phone = htmlspecialchars($_POST['phone']);
        $live_type = htmlspecialchars($_POST['live_type']);
        
        // اعتبارسنجی ساده
        $errors = [];
        if (empty($name)) $errors[] = "نام الزامی است";
        if (empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)) $errors[] = "ایمیل معتبر الزامی است";
        if (empty($phone)) $errors[] = "شماره تلفن الزامی است";
        
        // اگر خطایی وجود نداشت
        if (empty($errors)) {
            // ارسال اطلاعات به تلگرام
            $telegram_message = "📋 *ثبت نام جدید برای لایو زنده* 📋\n\n";
            $telegram_message .= "👤 *نام:* $name\n";
            $telegram_message .= "📧 *ایمیل:* $email\n";
            $telegram_message .= "📱 *تلفن:* $phone\n";
            $telegram_message .= "🎥 *نوع لایو:* $live_type\n";
            $telegram_message .= "💰 *هزینه:* ۲,۰۰۰ تومان\n";
            $telegram_message .= "⏰ *زمان ثبت‌نام:* " . date('Y-m-d H:i:s') . "\n";
            $telegram_message .= "🔗 *آی‌پی کاربر:* " . $_SERVER['REMOTE_ADDR'];
            
            // ارسال به تلگرام با استفاده از cURL
            $telegram_url = "https://api.telegram.org/bot{$telegram_bot_token}/sendMessage";
            $telegram_data = [
                'chat_id' => $telegram_chat_id,
                'text' => $telegram_message,
                'parse_mode' => 'Markdown'
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $telegram_url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $telegram_data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $telegram_response = curl_exec($ch);
            curl_close($ch);
            
            // هدایت به صفحه پرداخت
            header("Location: payment.php?live_type=" . urlencode($live_type) . 
                   "&name=" . urlencode($name) . 
                   "&email=" . urlencode($email) . 
                   "&phone=" . urlencode($phone));
            exit();
        }
    }
}

// پردازش انتخاب لایو
$selected_live = isset($_GET['live']) ? $_GET['live'] : null;
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لایوهای زنده ویژه</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #0a0a0a;
            color: #fff;
            overflow-x: hidden;
            min-height: 100vh;
            position: relative;
        }
        
        /* ذرات متحرک */
        #particles-js {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            z-index: 1;
            position: relative;
        }
        
        header {
            text-align: center;
            padding: 30px 0;
            position: relative;
        }
        
        .logo {
            font-size: 2.5rem;
            font-weight: bold;
            color: #ff0033;
            text-shadow: 0 0 15px rgba(255, 0, 51, 0.7);
            margin-bottom: 10px;
            letter-spacing: 2px;
        }
        
        .tagline {
            font-size: 1.2rem;
            color: #ff6699;
            margin-bottom: 30px;
            font-weight: 300;
        }
        
        .live-counter {
            background: rgba(255, 0, 51, 0.2);
            border: 1px solid #ff0033;
            border-radius: 50px;
            padding: 10px 25px;
            display: inline-block;
            margin-bottom: 20px;
            font-size: 1.1rem;
            box-shadow: 0 0 10px rgba(255, 0, 51, 0.5);
        }
        
        .live-indicator {
            display: inline-block;
            width: 12px;
            height: 12px;
            background-color: #ff0033;
            border-radius: 50%;
            margin-left: 10px;
            animation: pulse 1.5s infinite;
        }
        
        @keyframes pulse {
            0% { box-shadow: 0 0 0 0 rgba(255, 0, 51, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(255, 0, 51, 0); }
            100% { box-shadow: 0 0 0 0 rgba(255, 0, 51, 0); }
        }
        
        .lives-container {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 30px;
            margin-top: 40px;
        }
        
        .live-card {
            background: linear-gradient(145deg, rgba(40, 0, 10, 0.9), rgba(80, 0, 20, 0.9));
            border-radius: 15px;
            overflow: hidden;
            transition: all 0.3s ease;
            border: 1px solid rgba(255, 0, 51, 0.3);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.5);
            position: relative;
        }
        
        .live-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(255, 0, 51, 0.4);
            border-color: #ff0033;
        }
        
        .live-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, #ff0033, #ff6699);
        }
        
        .live-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
            border-bottom: 2px solid rgba(255, 0, 51, 0.5);
        }
        
        .live-content {
            padding: 20px;
        }
        
        .live-title {
            font-size: 1.5rem;
            color: #ff6699;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
        }
        
        .live-icon {
            margin-left: 10px;
            color: #ff0033;
        }
        
        .live-description {
            color: #e0e0e0;
            line-height: 1.6;
            margin-bottom: 20px;
            font-size: 0.95rem;
        }
        
        .viewers {
            color: #ff9999;
            font-size: 0.9rem;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        
        .viewers i {
            margin-left: 5px;
        }
        
        .viewer-count {
            font-weight: bold;
            color: #ff3366;
            margin-right: 5px;
        }
        
        .price-tag {
            background: rgba(255, 0, 51, 0.2);
            color: #ffcc00;
            padding: 5px 15px;
            border-radius: 20px;
            font-weight: bold;
            margin-bottom: 15px;
            display: inline-block;
            border: 1px solid rgba(255, 204, 0, 0.3);
        }
        
        .select-btn {
            background: linear-gradient(90deg, #ff0033, #ff3366);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 50px;
            cursor: pointer;
            font-size: 1rem;
            font-weight: bold;
            width: 100%;
            transition: all 0.3s ease;
            letter-spacing: 1px;
        }
        
        .select-btn:hover {
            background: linear-gradient(90deg, #cc0029, #ff0033);
            box-shadow: 0 0 15px rgba(255, 0, 51, 0.7);
        }
        
        /* فرم ثبت نام */
        .registration-form {
            display: <?php echo $selected_live ? 'block' : 'none'; ?>;
            max-width: 600px;
            margin: 50px auto;
            background: linear-gradient(145deg, rgba(40, 0, 10, 0.95), rgba(80, 0, 20, 0.95));
            border-radius: 15px;
            padding: 30px;
            border: 1px solid rgba(255, 0, 51, 0.5);
            box-shadow: 0 15px 30px rgba(255, 0, 51, 0.3);
        }
        
        .form-title {
            text-align: center;
            color: #ff6699;
            margin-bottom: 25px;
            font-size: 1.8rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .form-title i {
            margin-left: 10px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            color: #ff9999;
            font-weight: 500;
        }
        
        .form-input {
            width: 100%;
            padding: 12px 15px;
            background: rgba(0, 0, 0, 0.5);
            border: 1px solid rgba(255, 0, 51, 0.5);
            border-radius: 8px;
            color: white;
            font-size: 1rem;
            transition: all 0.3s ease;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #ff0033;
            box-shadow: 0 0 10px rgba(255, 0, 51, 0.5);
        }
        
        .payment-info {
            background: rgba(255, 204, 0, 0.1);
            border: 1px solid rgba(255, 204, 0, 0.3);
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            text-align: center;
        }
        
        .payment-amount {
            font-size: 1.8rem;
            color: #ffcc00;
            font-weight: bold;
            margin: 10px 0;
        }
        
        .payment-note {
            color: #ff9999;
            font-size: 0.9rem;
        }
        
        .error-message {
            color: #ff3366;
            background: rgba(255, 0, 51, 0.1);
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
            border-right: 3px solid #ff0033;
        }
        
        .success-message {
            color: #33ff99;
            background: rgba(0, 255, 128, 0.1);
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
            border-right: 3px solid #33ff99;
        }
        
        .back-btn {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.3);
            padding: 10px 20px;
            border-radius: 50px;
            cursor: pointer;
            margin-top: 15px;
            transition: all 0.3s ease;
        }
        
        .back-btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        
        footer {
            text-align: center;
            padding: 30px 0;
            margin-top: 50px;
            border-top: 1px solid rgba(255, 0, 51, 0.3);
            color: #ff9999;
            font-size: 0.9rem;
        }
        
        @media (max-width: 768px) {
            .lives-container {
                grid-template-columns: 1fr;
            }
            
            .subscription-options {
                flex-direction: column;
            }
            
            .logo {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <!-- ذرات متحرک -->
    <div id="particles-js"></div>
    
    <div class="container">
        <header>
            <div class="logo">LIVE HUB</div>
            <div class="tagline">تجربه‌ای داغ و فراموش‌نشدنی از لایوهای زنده</div>
            <div class="live-counter">
                <i class="fas fa-users"></i>
                <span id="total-viewers">۴۲ نفر در حال تماشا هستند</span>
                <span class="live-indicator"></span>
            </div>
        </header>
        
        <?php if (!empty($errors)): ?>
            <div class="registration-form" style="display: block;">
                <div class="error-message">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php foreach($errors as $error): ?>
                        <p><?php echo $error; ?></p>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- فرم ثبت نام -->
        <div class="registration-form" id="registrationForm">
            <div class="form-title">
                <i class="fas fa-user-plus"></i>
                ثبت نام برای لایو ویژه
            </div>
            
            <div class="payment-info">
                <p>هزینه تماشای این لایو:</p>
                <div class="payment-amount">۲,۰۰۰ تومان</div>
                <p class="payment-note">پس از پرداخت، بلافاصله به لایو دسترسی خواهید داشت</p>
            </div>
            
            <form method="POST" action="">
                <input type="hidden" name="action" value="register">
                <input type="hidden" name="live_type" value="<?php echo $selected_live; ?>">
                
                <div class="form-group">
                    <label class="form-label" for="name"><i class="fas fa-user"></i> نام و نام خانوادگی</label>
                    <input type="text" id="name" name="name" class="form-input" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="email"><i class="fas fa-envelope"></i> آدرس ایمیل</label>
                    <input type="email" id="email" name="email" class="form-input" required>
                </div>
                
                <div class="form-group">
                    <label class="form-label" for="phone"><i class="fas fa-phone"></i> شماره تلفن همراه</label>
                    <input type="tel" id="phone" name="phone" class="form-input" required>
                </div>
                
                <div class="form-group">
                    <button type="submit" class="select-btn">
                        <i class="fas fa-lock"></i>
                        ادامه به صفحه پرداخت
                    </button>
                </div>
            </form>
            
            <button class="back-btn" onclick="hideRegistrationForm()">
                <i class="fas fa-arrow-right"></i>
                بازگشت به لیست لایوها
            </button>
        </div>
        
        <!-- لیست لایوها -->
        <div class="lives-container" id="livesContainer">
            <!-- لایو دختر ایرانی -->
            <div class="live-card">
                <img src="https://saeeds.xyz/live/1.png" alt="دختر ایرانی" class="live-image">
                <div class="live-content">
                    <h3 class="live-title">
                        <i class="fas fa-fire live-icon"></i>
                        لایو دختر ایرانی
                    </h3>
                    <p class="live-description">
                        لایوی داغ و جذاب با زیباترین دختران ایرانی. گفتگوی صمیمی و فضایی گرم و صمیمی در انتظار شماست.
                    </p>
                    <div class="price-tag">هزینه تماشا: ۲,۰۰۰ تومان</div>
                    <div class="viewers">
                        <i class="fas fa-eye"></i>
                        <span class="viewer-count" id="viewers-1">۲۴۵</span>
                        <span>نفر در حال تماشا</span>
                    </div>
                    <form method="GET" action="">
                        <input type="hidden" name="live" value="لایو دختر ایرانی">
                        <button type="submit" class="select-btn">
                            <i class="fas fa-play-circle"></i>
                            تماشای این لایو (۲,۰۰۰ تومان)
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- لایو دختر خارجی -->
            <div class="live-card">
                <img src="https://saeeds.xyz/live/2.png" alt="دختر خارجی" class="live-image">
                <div class="live-content">
                    <h3 class="live-title">
                        <i class="fas fa-globe-americas live-icon"></i>
                        لایو دختر خارجی
                    </h3>
                    <p class="live-description">
                        ملاقات با زیباترین دختران از سراسر دنیا. تجربه‌ای بین‌المللی و هیجان‌انگیز برای شما.
                    </p>
                    <div class="price-tag">هزینه تماشا: ۲,۰۰۰ تومان</div>
                    <div class="viewers">
                        <i class="fas fa-eye"></i>
                        <span class="viewer-count" id="viewers-2">۱۸۷</span>
                        <span>نفر در حال تماشا</span>
                    </div>
                    <form method="GET" action="">
                        <input type="hidden" name="live" value="لایو دختر خارجی">
                        <button type="submit" class="select-btn">
                            <i class="fas fa-play-circle"></i>
                            تماشای این لایو (۲,۰۰۰ تومان)
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- لایو دو نفره -->
            <div class="live-card">
                <img src="https://saeeds.xyz/live/3.png" alt="دو نفره" class="live-image">
                <div class="live-content">
                    <h3 class="live-title">
                        <i class="fas fa-user-friends live-icon"></i>
                        لایو دو نفره
                    </h3>
                    <p class="live-description">
                        تجربه‌ای منحصربه‌فرد با دو میزبان جذاب. تعامل دوسویه و لحظاتی فراموش‌نشدنی.
                    </p>
                    <div class="price-tag">هزینه تماشا: ۲,۰۰۰ تومان</div>
                    <div class="viewers">
                        <i class="fas fa-eye"></i>
                        <span class="viewer-count" id="viewers-3">۳۲۱</span>
                        <span>نفر در حال تماشا</span>
                    </div>
                    <form method="GET" action="">
                        <input type="hidden" name="live" value="لایو دو نفره">
                        <button type="submit" class="select-btn">
                            <i class="fas fa-play-circle"></i>
                            تماشای این لایو (۲,۰۰۰ تومان)
                        </button>
                    </form>
                </div>
            </div>
            
            <!-- لایو داغ کاربر -->
            <div class="live-card">
                <img src="https://saeeds.xyz/live/4.png" alt="لایو داغ" class="live-image">
                <div class="live-content">
                    <h3 class="live-title">
                        <i class="fas fa-heart live-icon"></i>
                        لایو داغ کاربر
                    </h3>
                    <p class="live-description">
                        لایوی خاص و داغ بر اساس درخواست کاربران. شما تعیین می‌کنید چه چیزی می‌خواهید ببینید.
                    </p>
                    <div class="price-tag">هزینه تماشا: ۲,۰۰۰ تومان</div>
                    <div class="viewers">
                        <i class="fas fa-eye"></i>
                        <span class="viewer-count" id="viewers-4">۱۵۶</span>
                        <span>نفر در حال تماشا</span>
                    </div>
                    <form method="GET" action="">
                        <input type="hidden" name="live" value="لایو داغ کاربر">
                        <button type="submit" class="select-btn">
                            <i class="fas fa-play-circle"></i>
                            تماشای این لایو (۲,۰۰۰ تومان)
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <footer>
            <p>© ۲۰۲۳ LIVE HUB - تمامی حقوق محفوظ است.</p>
            <p>تمامی لایوها به صورت زنده و با بالاترین کیفیت ارائه می‌شوند.</p>
        </footer>
    </div>

    <!-- اسکریپت ذرات متحرک -->
    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        // راه‌اندازی ذرات متحرک
        particlesJS("particles-js", {
            particles: {
                number: { value: 80, density: { enable: true, value_area: 800 } },
                color: { value: "#ff0033" },
                shape: { type: "circle" },
                opacity: { value: 0.5, random: true },
                size: { value: 3, random: true },
                line_linked: {
                    enable: true,
                    distance: 150,
                    color: "#ff3366",
                    opacity: 0.4,
                    width: 1
                },
                move: {
                    enable: true,
                    speed: 2,
                    direction: "none",
                    random: true,
                    straight: false,
                    out_mode: "out",
                    bounce: false
                }
            },
            interactivity: {
                detect_on: "canvas",
                events: {
                    onhover: { enable: true, mode: "repulse" },
                    onclick: { enable: true, mode: "push" }
                }
            }
        });
        
        // نمایش فرم ثبت نام
        <?php if ($selected_live): ?>
            document.getElementById('livesContainer').style.display = 'none';
            document.getElementById('registrationForm').style.display = 'block';
        <?php endif; ?>
        
        // تابع بازگشت به لیست لایوها
        function hideRegistrationForm() {
            document.getElementById('registrationForm').style.display = 'none';
            document.getElementById('livesContainer').style.display = 'grid';
            window.history.pushState({}, document.title, window.location.pathname);
        }
        
        // تابع برای تغییر عدد تماشاگران بصورت خودکار
        function updateViewerCounts() {
            // مقادیر اولیه
            let baseCounts = [245, 187, 321, 156];
            let totalViewers = 0;
            
            // به روزرسانی تعداد تماشاگران هر لایو
            for (let i = 1; i <= 4; i++) {
                let base = baseCounts[i-1];
                // تغییر تصادفی بین -20 تا +20
                let change = Math.floor(Math.random() * 41) - 20;
                let newCount = Math.max(base + change, 50); // حداقل 50 نفر
                
                // نمایش عدد با فرمت فارسی
                let formattedCount = newCount.toLocaleString('fa-IR');
                document.getElementById(`viewers-${i}`).textContent = formattedCount;
                
                totalViewers += newCount;
            }
            
            // به روزرسانی تعداد کل تماشاگران
            let formattedTotal = totalViewers.toLocaleString('fa-IR');
            document.getElementById('total-viewers').textContent = `${formattedTotal} نفر در حال تماشا هستند`;
        }
        
        // شروع تغییر خودکار هر 5 ثانیه
        setInterval(updateViewerCounts, 5000);
        
        // اجرای اولیه
        updateViewerCounts();
    </script>
</body>
</html>