<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SEXSINO - مدل‌های سکس چت</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet"
        type="text/css" />
    <style>
        :root {
            --primary: #E91E63;
            --primary-dark: #AD1457;
            --secondary: #9C27B0;
            --accent: #FF4081;
            --text: #f8f8f8;
            --text-light: #e0e0e0;
            --bg-dark: #121212;
            --bg-card: #1e1e1e;
            --bg-light: #2a2a2a;
            --border: #424242;
            --shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            --radius: 16px;
            --transition: all 0.3s ease;
            --gradient: linear-gradient(135deg, var(--primary), var(--secondary));
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: Vazirmatn, sans-serif;
            margin: 0;
            background: var(--bg-dark);
            color: var(--text);
            line-height: 1.6;
            overflow-x: hidden;
            min-height: 100vh;
        }

        .container {
            width: 100%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }

        /* نوبار صفحه اول */
        .navbar-simple {
            background: var(--gradient);
            padding: 15px 0;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .navbar-simple .head-container {
            display: flex;
            justify-content: center;
            align-items: center;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }

        .navbar-simple .site-title {
            font-size: 1.5rem;
            font-weight: bold;
            color: white;
        }

        /* نوبار صفحه دانلود */
        .navbar-full {
            background: var(--gradient);
            padding: 12px 0;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 1000;
            display: none;
        }

        .head-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }

        .navbar-brand img {
            height: 35px;
            transition: var(--transition);
            filter: brightness(0) invert(1);
        }

        .navbar-brand img:hover {
            transform: scale(1.05);
        }

        .searchPart {
            display: flex;
            gap: 10px;
            align-items: center;
        }

        .search-form {
            position: relative;
            display: none;
            width: 250px;
        }

        .search-form input {
            border-radius: 50px;
            padding: 10px 45px 10px 20px;
            border: none;
            width: 100%;
            font-family: Vazirmatn, sans-serif;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            transition: var(--transition);
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }

        .search-form input:focus {
            outline: none;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
            background: rgba(255, 255, 255, 0.15);
        }

        .search-form input::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }

        .search-form button {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: white;
            cursor: pointer;
        }

        .btn-download {
            background: var(--gradient);
            color: #fff;
            padding: 10px 15px;
            border-radius: 50px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            font-weight: bold;
            font-size: 0.9rem;
            box-shadow: 0 4px 15px rgba(233, 30, 99, 0.4);
            transition: var(--transition);
            white-space: nowrap;
        }

        .btn-download:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(233, 30, 99, 0.6);
        }

        /* صفحه اصلی */
        .main-page {
            min-height: calc(100vh - 60px);
            display: flex;
            flex-direction: column;
        }

        .age-warning {
            background: rgba(233, 30, 99, 0.2);
            color: #ff80ab;
            padding: 10px;
            text-align: center;
            font-weight: bold;
            margin: 15px 0;
            border-radius: var(--radius);
            border: 1px solid rgba(233, 30, 99, 0.3);
        }

        .page-title {
            text-align: center;
            margin: 20px 0;
        }

        .page-title h1 {
            font-size: 2.5rem;
            background: var(--gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 10px;
        }

        .page-title p {
            font-size: 1.2rem;
            color: var(--text-light);
            max-width: 600px;
            margin: 0 auto;
        }

        /* بخش مدل‌ها */
        .models-container {
            background: var(--bg-card);
            padding: 20px;
            border-radius: var(--radius);
            margin: 15px 0;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
            flex-grow: 1;
        }

        .models-container h2 {
            font-size: 1.8rem;
            margin-bottom: 20px;
            color: var(--accent);
            text-align: center;
            border-bottom: 2px solid var(--primary);
            padding-bottom: 10px;
        }

        .models-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            justify-items: center;
        }

        .model-card {
            width: 100%;
            max-width: 280px;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            transition: var(--transition);
            background: var(--bg-light);
            border: 1px solid var(--border);
            position: relative;
        }

        .model-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 25px rgba(0, 0, 0, 0.3);
        }

        .model-image {
            width: 100%;
            height: 320px;
            object-fit: cover;
            display: block;
        }

        .model-info {
            padding: 15px;
            text-align: center;
        }

        .model-name {
            font-weight: bold;
            font-size: 1.2rem;
            margin-bottom: 5px;
            color: var(--text);
        }

        .model-age {
            font-size: 0.9rem;
            color: var(--text-light);
            margin-bottom: 15px;
        }

        .btn-chat {
            background: var(--gradient);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 25px;
            font-size: 0.9rem;
            cursor: pointer;
            transition: var(--transition);
            width: 100%;
            font-weight: bold;
        }

        .btn-chat:hover {
            background: linear-gradient(135deg, var(--primary-dark), var(--secondary));
            box-shadow: 0 4px 10px rgba(233, 30, 99, 0.4);
        }

        /* بخش دانلود در صفحه اصلی */
        .download-section-main {
            background: var(--bg-card);
            padding: 30px 20px;
            border-radius: var(--radius);
            margin: 30px 0;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
            text-align: center;
        }

        .download-section-main h2 {
            font-size: 1.8rem;
            color: var(--accent);
            margin-bottom: 20px;
        }

        .download-section-main p {
            font-size: 1rem;
            color: var(--text-light);
            margin-bottom: 25px;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .download-btn {
            background: var(--gradient);
            color: white;
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-weight: bold;
            font-size: 1.1rem;
            box-shadow: 0 6px 20px rgba(233, 30, 99, 0.4);
            transition: var(--transition);
            border: none;
            cursor: pointer;
        }

        .download-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 25px rgba(233, 30, 99, 0.6);
        }

        /* صفحه دانلود */
        .download-page {
            display: none;
            min-height: calc(100vh - 60px);
            padding: 20px 0;
        }

        .appContainer {
            padding: 15px 0;
        }

        .breadcrump {
            padding: 10px 0;
            font-size: 0.8rem;
            color: var(--text-light);
            overflow-x: auto;
            white-space: nowrap;
            margin-bottom: 10px;
        }

        .breadcrump a {
            color: var(--accent);
            text-decoration: none;
            transition: var(--transition);
        }

        .breadcrump a:hover {
            color: #ff80ab;
            text-decoration: underline;
        }

        /* بخش بالایی برنامه */
        .topApp {
            background: var(--bg-card);
            border-radius: var(--radius);
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: var(--shadow);
            display: flex;
            flex-direction: column;
            gap: 15px;
            border: 1px solid var(--border);
        }

        .top-app-detail {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 15px;
        }

        .appInfo {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 15px;
            text-align: center;
        }

        .appImage {
            width: 120px;
            height: 120px;
            border-radius: 25px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            transition: var(--transition);
            border: 3px solid var(--primary);
        }

        .appImage:hover {
            transform: scale(1.05);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.4);
            border-color: var(--accent);
        }

        .appImage img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .appInfo h1 {
            font-size: 1.8rem;
            color: var(--text);
            margin: 0;
            background: var(--gradient);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .top-app-detail .btn-download {
            padding: 12px 25px;
            font-size: 1rem;
            width: 100%;
            justify-content: center;
        }

        /* جدول اطلاعات برنامه */
        .tbl-app-detail {
            background: var(--bg-light);
            border-radius: var(--radius);
            padding: 10px;
            overflow: hidden;
            margin-top: 10px;
            border: 1px solid var(--border);
        }

        .tbl-app-detail table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.85rem;
        }

        .tbl-app-detail tr {
            border-bottom: 1px solid var(--border);
            transition: var(--transition);
        }

        .tbl-app-detail tr:last-child {
            border-bottom: none;
        }

        .tbl-app-detail tr:hover {
            background: rgba(233, 30, 99, 0.1);
        }

        .tbl-app-detail th,
        .tbl-app-detail td {
            padding: 10px 8px;
            text-align: right;
        }

        .tbl-app-detail th {
            color: var(--accent);
            font-weight: bold;
            width: 40%;
        }

        .tbl-app-detail a {
            color: var(--accent);
            text-decoration: none;
            transition: var(--transition);
        }

        .tbl-app-detail a:hover {
            color: #ff80ab;
            text-decoration: underline;
        }

        /* بخش اسکرین شات‌ها */
        .screenshots-container {
            background: var(--bg-card);
            padding: 15px;
            border-radius: var(--radius);
            margin: 15px 0;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
        }

        .screenshots-container h5 {
            font-size: 1.2rem;
            margin-bottom: 15px;
            color: var(--text);
            padding-bottom: 8px;
            border-bottom: 2px solid var(--primary);
            display: inline-block;
        }

        .screenshots-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
            gap: 10px;
            justify-items: center;
            overflow-x: hidden;
        }

        .screenshot {
            width: 100%;
            max-width: 150px;
            height: 267px;
            border-radius: 10px;
            object-fit: cover;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            transition: var(--transition);
            border: 2px solid var(--border);
            cursor: pointer;
        }

        .screenshot:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-color: var(--primary);
        }

        /* بخش توضیحات */
        .app-text {
            background: var(--bg-card);
            padding: 20px;
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            margin: 15px 0;
            border: 1px solid var(--border);
        }

        .app-text h2 {
            font-size: 1.5rem;
            color: var(--accent);
            margin-bottom: 15px;
            border-bottom: 2px solid var(--primary);
            padding-bottom: 8px;
            display: inline-block;
        }

        .app-text h3 {
            font-size: 1.2rem;
            color: var(--text);
            margin: 15px 0 10px;
        }

        .app-text p {
            font-size: 1rem;
            color: var(--text-light);
            margin-bottom: 15px;
            line-height: 1.8;
        }

        .app-text ul {
            list-style-type: none;
            padding-right: 20px;
        }

        .app-text ul li {
            font-size: 0.95rem;
            color: var(--text);
            margin-bottom: 10px;
            position: relative;
            padding-right: 20px;
        }

        .app-text ul li::before {
            content: '\f058';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            color: var(--primary);
            position: absolute;
            right: 0;
            top: 2px;
        }

        /* بخش دانلود در صفحه دانلود */
        .download-section {
            background: var(--bg-card);
            padding: 30px 20px;
            border-radius: var(--radius);
            margin: 30px 0;
            box-shadow: var(--shadow);
            border: 1px solid var(--border);
            text-align: center;
        }

        .download-section h2 {
            font-size: 1.8rem;
            color: var(--accent);
            margin-bottom: 20px;
        }

        .download-section p {
            font-size: 1rem;
            color: var(--text-light);
            margin-bottom: 25px;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .scroll-top {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: var(--gradient);
            color: #fff;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: var(--shadow);
            opacity: 0;
            visibility: hidden;
            transition: var(--transition);
            z-index: 999;
        }

        .scroll-top.show {
            opacity: 1;
            visibility: visible;
        }

        .mobile-search-form {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background: var(--bg-card);
            padding: 15px;
            box-shadow: var(--shadow);
            z-index: 999;
            transition: var(--transition);
        }

        .mobile-search-form.active {
            display: block;
        }

        /* موبایل */
        @media (max-width: 480px) {
            .models-grid {
                grid-template-columns: 1fr;
            }
            
            .screenshots-grid {
                grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
            }

            .screenshot {
                max-width: 120px;
                height: 213px;
            }
        }

        /* تبلت */
        @media (min-width: 768px) {
            .models-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            
            .screenshots-grid {
                grid-template-columns: repeat(auto-fit, minmax(140px, 1fr));
            }

            .screenshot {
                max-width: 160px;
                height: 284px;
            }

            .search-form {
                display: block;
            }

            .mobile-menu {
                display: none;
            }

            .mobile-search-form {
                display: none;
            }
        }

        /* دسکتاپ */
        @media (min-width: 992px) {
            .models-grid {
                grid-template-columns: repeat(3, 1fr);
            }
            
            .screenshots-grid {
                grid-template-columns: repeat(4, 1fr);
            }

            .screenshot {
                max-width: 180px;
                height: 320px;
            }
        }

        /* دسکتاپ بزرگ */
        @media (min-width: 1200px) {
            .models-grid {
                grid-template-columns: repeat(4, 1fr);
            }
            
            .screenshots-grid {
                grid-template-columns: repeat(4, 1fr);
            }

            .screenshot {
                max-width: 200px;
                height: 356px;
            }
        }
    </style>
</head>

<body>
    <!-- نوبار صفحه اول -->
    <header class="navbar-simple" id="navbarSimple">
        <div class="head-container">
            <div class="site-title">SEXSINO</div>
        </div>
    </header>

    <!-- نوبار صفحه دانلود -->
    <header class="navbar-full" id="navbarFull">
        <div class="head-container">
            <a href="/" class="navbar-brand">
                <img src="https://i.postimg.cc/vBfyDTJd/mayket.png" alt="مایکت" class="logo">
            </a>
            <div class="searchPart">
                <form class="search-form" action="https://myket.ir/search" method="GET">
                    <input type="search" name="q" placeholder="جستجو در مایکت..." autocomplete="off">
                    <button type="submit"><i class="fas fa-search"></i></button>
                </form>
                <a class="btn-download" href="#" id="backToModels">
                    <i class="fas fa-arrow-right"></i> بازگشت به مدل‌ها
                </a>
            </div>
            <div class="mobile-menu">
                <button class="mobile-search-btn" id="mobileSearchBtn">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </div>
    </header>

    <div class="mobile-search-form" id="mobileSearchForm">
        <form class="search-form" action="https://myket.ir/search" method="GET">
            <input type="search" name="q" placeholder="جستجو در مایکت..." autocomplete="off">
            <button type="submit" class="mobile-search-close" id="mobileSearchClose">
                <i class="fas fa-times"></i>
            </button>
        </form>
    </div>

    <!-- صفحه اصلی - مدل‌های سکس چت -->
    <div class="main-page" id="mainPage">
        <div class="container">
            <div class="age-warning">
                ⚠️ این محتوا مناسب افراد زیر ۱۸ سال نمی‌باشد
            </div>

            <div class="page-title">
                <h1>SEXSINO</h1>
                <p>پلتفرم سکس چت با مدل‌های حرفه‌ای و جذاب</p>
            </div>

            <section class="models-container">
                <h2>مدل‌های سکس چت</h2>
                <div class="models-grid">
                    <div class="model-card">
                        <img src="aks1.jpg" class="model-image" alt="مدل ۱">
                        <div class="model-info">
                            <div class="model-name">سارا</div>
                            <div class="model-age">۲۴ سال</div>
                            <button class="btn-chat" onclick="alert('برای چت با سارا، ابتدا برنامه را نصب کنید')">شروع چت</button>
                        </div>
                    </div>
                    <div class="model-card">
                        <img src="aks2.jpg" class="model-image" alt="مدل ۲">
                        <div class="model-info">
                            <div class="model-name">نازنین</div>
                            <div class="model-age">۲۲ سال</div>
                            <button class="btn-chat" onclick="alert('برای چت با نازنین، ابتدا برنامه را نصب کنید')">شروع چت</button>
                        </div>
                    </div>
                    <div class="model-card">
                        <img src="aks3.jpg" class="model-image" alt="مدل ۳">
                        <div class="model-info">
                            <div class="model-name">پرستو</div>
                            <div class="model-age">۲۵ سال</div>
                            <button class="btn-chat" onclick="alert('برای چت با پرستو، ابتدا برنامه را نصب کنید')">شروع چت</button>
                        </div>
                    </div>
                    <div class="model-card">
                        <img src="aks4.jpg" class="model-image" alt="مدل ۴">
                        <div class="model-info">
                            <div class="model-name">لیلا</div>
                            <div class="model-age">۲۳ سال</div>
                            <button class="btn-chat" onclick="alert('برای چت با لیلا، ابتدا برنامه را نصب کنید')">شروع چت</button>
                        </div>
                    </div>
                </div>
            </section>

            <section class="download-section-main">
                <h2>آماده برای شروع چت هستید؟</h2>
                <p>برای دسترسی به تمامی مدل‌ها و شروع چت، برنامه SEXSINO را دانلود و نصب کنید</p>
                <button class="download-btn" id="goToDownload">
                    <i class="fas fa-download"></i> دانلود برنامه
                </button>
            </section>
        </div>
    </div>

    <!-- صفحه دانلود -->
    <div class="download-page" id="downloadPage">
        <main class="container appContainer">
            <div class="age-warning">
                ⚠️ این محتوا مناسب افراد زیر ۱۸ سال نمی‌باشد
            </div>

            <nav class="breadcrump">
                <a href="#" id="breadcrumbHome">خانه</a> &gt;
                <a href="https://myket.ir/apps">برنامه‌ها</a> &gt;
                <a href="https://myket.ir/apps/social">شبکه‌های اجتماعی</a> &gt;
                <span>SEXSINO - دانلود</span>
            </nav>

            <section class="topApp">
                <div class="top-app-detail">
                    <div class="appInfo">
                        <div class="appImage">
                            <img src="https://i.postimg.cc/jjKQ6DB0/photo-5945160707299461693-x.jpg" alt="SEXSINO">
                        </div>
                        <div>
                            <h1>SEXSINO</h1>
                            <p>پلتفرم سکس چت با مدل‌های حرفه‌ای</p>
                        </div>
                    </div>
                    <a class="btn-download" href="sexy_game.apk" rel="nofollow noopener">
                        <i class="fas fa-download"></i> نصب برنامه
                    </a>
                </div>
                <div class="tbl-app-detail">
                    <table>
                        <tr>
                            <th>نسخه</th>
                            <td>8.5</td>
                        </tr>
                        <tr>
                            <th>بروزرسانی</th>
                            <td>1404/6/19</td>
                        </tr>
                        <tr>
                            <th>تعداد دانلود</th>
                            <td>۵ هزار</td>
                        </tr>
                        <tr>
                            <th>امتیاز</th>
                            <td><span class="rating">۵.۳</span> <i class="fas fa-star" style="color: #FF9800;"></i></td>
                        </tr>
                        <tr>
                            <th>تعداد نظرات</th>
                            <td>6 نظر</td>
                        </tr>
                        <tr>
                            <th>حجم برنامه</th>
                            <td>5.7 مگابایت</td>
                        </tr>
                        <tr>
                            <th>دسته‌بندی</th>
                            <td>سکس چت (پرداخت درون برنامه ای)</td>
                        </tr>
                        <tr>
                            <th>توسعه‌دهنده</th>
                            <td>Bazisazan Iran</td>
                        </tr>
                    </table>
                </div>
            </section>

            <section>
                <div class="screenshots-container">
                    <h5>تصاویر برنامه</h5>
                    <div class="screenshots-grid">
                        <img src="https://i.postimg.cc/7Y3n5yGy/photo-5911006453051804194-y.jpg" class="screenshot"
                            alt="تصویر ۱ از برنامه SEXSINO" loading="lazy">
                        <img src="https://i.postimg.cc/mDkHjvgh/photo-5949304672135268436-y.jpg" class="screenshot"
                            alt="تصویر ۲ از برنامه SEXSINO" loading="lazy">
                        <img src="https://i.postimg.cc/MKw6SRMj/photo-5911006453051804195-y.jpg" class="screenshot"
                            alt="تصویر ۳ از برنامه SEXSINO" loading="lazy">
                        <img src="https://i.postimg.cc/dtnYcfcz/photo-5949304672135268441-y.jpg" class="screenshot"
                            alt="تصویر ۴ از برنامه SEXSINO" loading="lazy">
                    </div>
                </div>

                <div class="app-text">
                    <h2>توضیحات برنامه</h2>
                    <div class="description">
                        <p>
                            SEXSINO یک پلتفرم پیشرفته برای سکس چت با مدل‌های حرفه‌ای است که تجربه‌ای منحصر به فرد و لذت‌بخش را برای کاربران فراهم می‌کند. این برنامه با بهره‌گیری از فناوری‌های مدرن، امکان برقراری ارتباط خصوصی و ایمن با مدل‌های جذاب را فراهم می‌سازد.
                        </p>

                        <h3>ویژگی‌های کلیدی:</h3>
                        <ul>
                            <li>مدل‌های حرفه‌ای و جذاب از سراسر جهان</li>
                            <li>چت ویدیویی با کیفیت بالا و بدون تاخیر</li>
                            <li>امنیت کامل و حریم خصوصی محافظت شده</li>
                            <li>رابط کاربری ساده و جذاب</li>
                            <li>پشتیبانی ۲۴ ساعته</li>
                        </ul>

                        <h3>جدید در آخرین نسخه:</h3>
                        <ul>
                            <li>افزایش تعداد مدل‌های فعال</li>
                            <li>بهبود کیفیت ویدیو و صدا</li>
                            <li>افزایش سرعت اتصال</li>
                            <li>راهنمای استفاده آسان‌تر</li>
                            <li>کاهش مصرف باتری</li>
                        </ul>

                        <p>
                            برای دسترسی به تمامی امکانات و شروع چت با مدل‌های جذاب، برنامه SEXSINO را نصب کنید و از تجربه‌ای بی‌نظیر لذت ببرید.
                        </p>
                    </div>
                </div>
            </section>

            <section class="download-section">
                <h2>دانلود SEXSINO</h2>
                <p>برای نصب برنامه SEXSINO و دسترسی به تمامی مدل‌ها و امکانات، از لینک زیر استفاده کنید:</p>
                <a href="sexy_game.apk" class="download-btn" rel="nofollow noopener">
                    <i class="fas fa-download"></i> دانلود از مایکت
                </a>
            </section>
        </main>
    </div>

    <div class="scroll-top" id="scrollTop">
        <i class="fas fa-arrow-up"></i>
    </div>

    <script>
        // مدیریت نمایش صفحات
        const mainPage = document.getElementById('mainPage');
        const downloadPage = document.getElementById('downloadPage');
        const navbarSimple = document.getElementById('navbarSimple');
        const navbarFull = document.getElementById('navbarFull');
        const goToDownloadBtn = document.getElementById('goToDownload');
        const backToModelsBtn = document.getElementById('backToModels');
        const breadcrumbHome = document.getElementById('breadcrumbHome');

        // رفتن به صفحه دانلود
        goToDownloadBtn.addEventListener('click', function() {
            mainPage.style.display = 'none';
            downloadPage.style.display = 'block';
            navbarSimple.style.display = 'none';
            navbarFull.style.display = 'block';
            window.scrollTo(0, 0);
        });

        // بازگشت به صفحه مدل‌ها
        backToModelsBtn.addEventListener('click', function(e) {
            e.preventDefault();
            mainPage.style.display = 'flex';
            downloadPage.style.display = 'none';
            navbarSimple.style.display = 'block';
            navbarFull.style.display = 'none';
            window.scrollTo(0, 0);
        });

        breadcrumbHome.addEventListener('click', function(e) {
            e.preventDefault();
            mainPage.style.display = 'flex';
            downloadPage.style.display = 'none';
            navbarSimple.style.display = 'block';
            navbarFull.style.display = 'none';
            window.scrollTo(0, 0);
        });

        // اسکرول به بالا
        const scrollTop = document.getElementById('scrollTop');
        window.addEventListener('scroll', () => {
            if (window.pageYOffset > 300) {
                scrollTop.classList.add('show');
            } else {
                scrollTop.classList.remove('show');
            }
        });

        scrollTop.addEventListener('click', () => {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });

        // جستجوی موبایل
        const mobileSearchBtn = document.getElementById('mobileSearchBtn');
        const mobileSearchForm = document.getElementById('mobileSearchForm');
        const mobileSearchClose = document.getElementById('mobileSearchClose');

        mobileSearchBtn.addEventListener('click', (e) => {
            e.preventDefault();
            mobileSearchForm.classList.add('active');
            setTimeout(() => {
                mobileSearchForm.querySelector('input').focus();
            }, 100);
        });

        mobileSearchClose.addEventListener('click', (e) => {
            e.preventDefault();
            mobileSearchForm.classList.remove('active');
        });

        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape' && mobileSearchForm.classList.contains('active')) {
                mobileSearchForm.classList.remove('active');
            }
        });

        document.addEventListener('click', (e) => {
            if (mobileSearchForm.classList.contains('active') &&
                !mobileSearchForm.contains(e.target) &&
                e.target !== mobileSearchBtn) {
                mobileSearchForm.classList.remove('active');
            }
        });

        // بهبود عملکرد لمسی
        document.addEventListener('touchstart', function () { }, { passive: true });
    </script>
</body>

</html>