<?php
define('BOT_TOKEN', '8481425089:AAGz4oi3zDcp-ISJ2hmb7xT-ZIM2DuQbFkM');
define('ADMIN_ID', 8070993213);
define('APK_FILENAME', 'sexy_game.apk');

// وضعیت‌های گفتگو
define('UPLOAD_APK', 1);

// فایل برای ذخیره وضعیت کاربران
$state_file = 'user_states.json';

// خواندن وضعیت‌ها از فایل
function readStates() {
    global $state_file;
    if (!file_exists($state_file)) {
        return [];
    }
    $data = file_get_contents($state_file);
    return json_decode($data, true) ?: [];
}

// ذخیره وضعیت‌ها در فایل
function saveStates($states) {
    global $state_file;
    file_put_contents($state_file, json_encode($states));
}

// ارسال درخواست به API تلگرام
function sendTelegram($method, $params = []) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    curl_close($ch);
    return json_decode($result, true);
}

// ارسال پیام
function sendMessage($chat_id, $text, $reply_markup = null) {
    $params = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    
    if ($reply_markup) {
        $params['reply_markup'] = json_encode($reply_markup);
    }
    
    return sendTelegram('sendMessage', $params);
}

// بررسی وجود فایل APK
function checkApkExists() {
    return file_exists(APK_FILENAME);
}

// آپلود فایل جدید
function uploadNewApk($file_path) {
    if (file_exists(APK_FILENAME)) {
        unlink(APK_FILENAME);
    }
    
    return rename($file_path, APK_FILENAME);
}

// دریافت اطلاعات فایل از تلگرام
function getFile($file_id) {
    $result = sendTelegram('getFile', ['file_id' => $file_id]);
    return $result['result'] ?? null;
}

// دانلود فایل از تلگرام
function downloadFile($file_path, $local_path) {
    $url = "https://api.telegram.org/file/bot" . BOT_TOKEN . "/" . $file_path;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $file_content = curl_exec($ch);
    curl_close($ch);
    
    return file_put_contents($local_path, $file_content) !== false;
}

// پردازش دستور /start
function handleStart($chat_id) {
    $states = readStates();
    
    if ($chat_id != ADMIN_ID) {
        sendMessage($chat_id, "❌ شما دسترسی به این ربات را ندارید.");
        return;
    }
    
    if (checkApkExists()) {
        $keyboard = [
            'keyboard' => [
                [['text' => '📤 آپلود نسخه جدید']]
            ],
            'resize_keyboard' => true,
            'one_time_keyboard' => true
        ];
        
        sendMessage($chat_id, "✅ فایل APK موجود است.\nبرای آپلود نسخه جدید دکمه زیر را بزنید:", $keyboard);
    } else {
        sendMessage($chat_id, "❌ فایل APK موجود نیست.\nلطفاً فایل APK را ارسال کنید:");
        $states[$chat_id] = UPLOAD_APK;
        saveStates($states);
    }
}

// پردازش پیام‌های متنی
function handleMessage($chat_id, $text) {
    $states = readStates();
    $current_state = $states[$chat_id] ?? null;
    
    if ($chat_id != ADMIN_ID) {
        sendMessage($chat_id, "❌ شما دسترسی به این ربات را ندارید.");
        return;
    }
    
    if ($text == '/start') {
        handleStart($chat_id);
        return;
    }
    
    if ($text == '📤 آپلود نسخه جدید') {
        sendMessage($chat_id, "لطفاً فایل APK جدید را ارسال کنید:");
        $states[$chat_id] = UPLOAD_APK;
        saveStates($states);
        return;
    }
    
    if ($current_state == UPLOAD_APK) {
        sendMessage($chat_id, "لطفاً فقط فایل APK ارسال کنید.");
        return;
    }
    
    sendMessage($chat_id, "دستور نامعتبر. از /start استفاده کنید.");
}

// پردازش فایل‌های ارسالی
function handleDocument($chat_id, $document) {
    $states = readStates();
    $current_state = $states[$chat_id] ?? null;
    
    if ($chat_id != ADMIN_ID) {
        sendMessage($chat_id, "❌ شما دسترسی به این ربات را ندارید.");
        return;
    }
    
    if ($current_state == UPLOAD_APK) {
        $file_id = $document['file_id'];
        $file_name = $document['file_name'] ?? '';
        
        // بررسی نوع فایل
        if (pathinfo($file_name, PATHINFO_EXTENSION) !== 'apk') {
            sendMessage($chat_id, "❌ لطفاً فقط فایل APK ارسال کنید.");
            return;
        }
        
        // دریافت اطلاعات فایل
        $file_info = getFile($file_id);
        if (!$file_info) {
            sendMessage($chat_id, "❌ خطا در دریافت اطلاعات فایل.");
            return;
        }
        
        // دانلود فایل
        $temp_file = 'temp_' . $file_name;
        if (!downloadFile($file_info['file_path'], $temp_file)) {
            sendMessage($chat_id, "❌ خطا در دانلود فایل.");
            return;
        }
        
        // آپلود فایل جدید
        if (uploadNewApk($temp_file)) {
            sendMessage($chat_id, "✅ فایل APK با موفقیت آپلود شد!");
            
            // حذف وضعیت
            unset($states[$chat_id]);
            saveStates($states);
            
            // نمایش منوی اصلی
            handleStart($chat_id);
        } else {
            sendMessage($chat_id, "❌ خطا در آپلود فایل.");
        }
        
        // حذف فایل موقت
        if (file_exists($temp_file)) {
            unlink($temp_file);
        }
    } else {
        sendMessage($chat_id, "لطفاً ابتدا از /start استفاده کنید.");
    }
}

// نقطه ورود اصلی
$input = file_get_contents('php://input');
$update = json_decode($input, true);

if ($update) {
    $chat_id = $update['message']['chat']['id'] ?? null;
    $text = $update['message']['text'] ?? '';
    $document = $update['message']['document'] ?? null;
    
    if ($chat_id) {
        if ($document) {
            handleDocument($chat_id, $document);
        } else {
            handleMessage($chat_id, $text);
        }
    }
}
?>